unit fGenPrint;
{ DATE CREATED:  9-99
  CREATED BY:    user   user, PORTLAND VAMC 
  DESCRIPTION:   GENERIC PRINT MODULE
  MODIFIED: }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fAutoSz, ORCtrls, StdCtrls, Mask, ORNet, ORFn, uCore;

type
  TfrmGenPrint = class(TfrmAutoSz)
    grpDevice: TGroupBox;
    lblMargin: TLabel;
    lblLength: TLabel;
    txtRightMargin: TMaskEdit;
    txtPageLength: TMaskEdit;
    cmdOK: TButton;
    cmdCancel: TButton;
    lblPrintTitle: TLabel;
    cboDevice: TORComboBox;
    lblPrintTo: TLabel;
    lstText: TORListBox;
    lstHdr: TORListBox;
    procedure cboDeviceNeedData(Sender: TObject; const StartFrom: String;
      Direction, InsertAt: Integer);
    procedure FormCreate(Sender: TObject);
    procedure cboDeviceChange(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
  private
    { Private declarations }
    procedure DisplaySelectDevice;
  public
    { Public declarations }
  end;

var
  PrPieces, PrTabs, Mar, Len: string;

procedure GenPrint(lstTemp: TORListBox; Title, TPieces, TTabs: string; lstPTemp: TORListBox);

implementation

{$R *.DFM}

uses rCore;

const
  TX_NODEVICE = 'A device must be selected to print, or press ''Cancel'' to not print.';
  TX_NODEVICE_CAP = 'Device Not Selected';
  TX_ERR_CAP = 'Print Error';
  TX_QUEUED_CAP = 'Printing Report' ;

procedure GenPrint(lstTemp: TORListBox; Title, TPieces, TTabs: string; lstPTemp: TORListBox);
{ displays a form that prompts for a device and then prints the text }
var
  frmGenPrint: TfrmGenPrint;
  I: integer;
begin
  frmGenPrint := TfrmGenPrint.Create(Application);
  try
    ResizeFormToFont(TForm(frmGenPrint));
    with frmGenPrint do
    begin
      for I := 0 to lstTemp.Items.Count-1 do lstText.Items.Add(lstTemp.Items[I]);
      for I := 0 to lstPTemp.Items.Count-1 do lstHdr.Items.Add(lstPTemp.Items[I]);
      lblPrintTitle.Caption := Title;
      PrPieces := TPieces;
      PrTabs   := TTabs;
      ShowModal;
    end;
  finally
    frmGenPrint.Release;
  end;
end;

procedure TfrmGenPrint.FormCreate(Sender: TObject);
begin
  inherited;
  cboDevice.InitLongList('');
end;

procedure TfrmGenPrint.DisplaySelectDevice;
begin
  with cboDevice, lblPrintTo do
  begin
    Caption := 'Print on:  ' + Piece(ItemID, ';', 2);
  end;
end;

procedure TfrmGenPrint.cboDeviceNeedData(Sender: TObject; const StartFrom: string;
  Direction, InsertAt: Integer);
begin
  inherited;
  cboDevice.ForDataUse(SubsetOfDevices(StartFrom, Direction));
end;

procedure TfrmGenPrint.cboDeviceChange(Sender: TObject);
begin
  inherited;
  with cboDevice do if ItemIndex > -1 then
  begin
    Mar := Piece(Items[ItemIndex], '^', 4);
    Len := Piece(Items[ItemIndex], '^', 5);
    txtRightMargin.Text := Mar;
    txtPageLength.Text  := Len;
    DisplaySelectDevice;
  end;
end;

procedure TfrmGenPrint.cmdOKClick(Sender: TObject);
var
  ADevice, ErrMsg, PTitle: string;
begin
  inherited;
  if cboDevice.ItemID = '' then
  begin
    InfoBox(TX_NODEVICE, TX_NODEVICE_CAP, MB_OK);
    Exit;
  end;
  ADevice := Piece(cboDevice.ItemID, ';', 2);
  PTitle := lblPrintTitle.Caption;
  ErrMsg := sCallV('APTWL PRINT', [lstText.Items, PTitle, ADevice, Mar, Len, PrPieces, PrTabs, lstHdr.Items]);
  if Piece(ErrMsg,U,1) = '0' then InfoBox(Piece(ErrMsg,U,2), TX_ERR_CAP, MB_OK)
  else InfoBox(Piece(ErrMsg,U,2), TX_QUEUED_CAP, MB_OK);
  Close;
end;

procedure TfrmGenPrint.cmdCancelClick(Sender: TObject);
begin
  inherited;
  Close;
end;

end.
